/*  =========================================================================
    zyre_classes - private header file

    Copyright (c) the Contributors as noted in the AUTHORS file.

    This file is part of Zyre, an open-source framework for proximity-based
    peer-to-peer applications -- See http://zyre.org.

    This Source Code Form is subject to the terms of the Mozilla Public
    License, v. 2.0. If a copy of the MPL was not distributed with this
    file, You can obtain one at http://mozilla.org/MPL/2.0/.
################################################################################
#  THIS FILE IS 100% GENERATED BY ZPROJECT; DO NOT EDIT EXCEPT EXPERIMENTALLY  #
#  Read the zproject/README.md for information about making permanent changes. #
################################################################################
    =========================================================================
*/

#ifndef ZYRE_CLASSES_H_INCLUDED
#define ZYRE_CLASSES_H_INCLUDED

//  Platform definitions, must come first
#include "platform.h"

//  Asserts check the invariants of methods. If they're not
//  fulfilled the program should fail fast. Therefore enforce them!
#ifdef NDEBUG
  #undef NDEBUG
  #include <assert.h>
  #define NDEBUG
#else
  #include <assert.h>
#endif

//  External API
#include "../include/zyre.h"

//  Private external dependencies

//  Opaque class structures to allow forward references
#ifndef ZRE_MSG_T_DEFINED
typedef struct _zre_msg_t zre_msg_t;
#define ZRE_MSG_T_DEFINED
#endif
#ifndef ZYRE_PEER_T_DEFINED
typedef struct _zyre_peer_t zyre_peer_t;
#define ZYRE_PEER_T_DEFINED
#endif
#ifndef ZYRE_GROUP_T_DEFINED
typedef struct _zyre_group_t zyre_group_t;
#define ZYRE_GROUP_T_DEFINED
#endif
#ifndef ZYRE_ELECTION_T_DEFINED
typedef struct _zyre_election_t zyre_election_t;
#define ZYRE_ELECTION_T_DEFINED
#endif
#ifndef ZYRE_NODE_T_DEFINED
typedef struct _zyre_node_t zyre_node_t;
#define ZYRE_NODE_T_DEFINED
#endif

//  Extra headers

//  Internal API

#include "zre_msg.h"
#include "zyre_peer.h"
#include "zyre_group.h"
#include "zyre_election.h"
#include "zyre_node.h"

//  *** To avoid double-definitions, only define if building without draft ***
#ifndef ZYRE_BUILD_DRAFT_API

//  *** Draft global constants, defined for internal use only ***
// Default ZAP domain (auth)
#define ZAP_DOMAIN_DEFAULT	"global"


//  *** Draft method, defined for internal use only ***
//  Set the TCP port bound by the ROUTER peer-to-peer socket (beacon mode).
//  Defaults to * (the port is randomly assigned by the system).
//  This call overrides this, to bypass some firewall issues when ports are
//  random. Has no effect after zyre_start().
ZYRE_PRIVATE void
    zyre_set_beacon_peer_port (zyre_t *self, int port_nbr);

//  *** Draft method, defined for internal use only ***
//  Unpublish a GOSSIP node from local list, useful in removing nodes from list when they EXIT
ZYRE_PRIVATE void
    zyre_gossip_unpublish (zyre_t *self, const char *node);

//  *** Draft method, defined for internal use only ***
//  Explicitly connect to a peer
ZYRE_PRIVATE int
    zyre_require_peer (zyre_t *self, const char *uuid, const char *endpoint, const char *public_key);

//  *** Draft method, defined for internal use only ***
//  Return underlying ZMQ socket for talking to the Zyre node,
//  for polling with libzmq (base ZMQ library)
ZYRE_PRIVATE void *
    zyre_socket_zmq (zyre_t *self);

//  *** Draft method, defined for internal use only ***
//  Self test of this class.
ZYRE_PRIVATE void
    zre_msg_test (bool verbose);

//  *** Draft method, defined for internal use only ***
//  Self test of this class.
ZYRE_PRIVATE void
    zyre_peer_test (bool verbose);

//  *** Draft method, defined for internal use only ***
//  Self test of this class.
ZYRE_PRIVATE void
    zyre_group_test (bool verbose);

//  *** Draft method, defined for internal use only ***
//  Self test of this class.
ZYRE_PRIVATE void
    zyre_election_test (bool verbose);

//  *** Draft method, defined for internal use only ***
//  Self test of this class.
ZYRE_PRIVATE void
    zyre_node_test (bool verbose);

//  Self test for private classes
ZYRE_PRIVATE void
    zyre_private_selftest (bool verbose, const char *subtest);

#endif // ZYRE_BUILD_DRAFT_API

//  Private constants

// Once per second
#define REAP_INTERVAL	1000

#endif
