################################################################################
#  THIS FILE IS 100% GENERATED BY ZPROJECT; DO NOT EDIT EXCEPT EXPERIMENTALLY  #
#  Read the zproject/README.md for information about making permanent changes. #
################################################################################
from . import utils
from . import destructors
libzyre_destructors = destructors.lib

class Zyre(object):
    """
    An open-source framework for proximity-based P2P apps
    """

    def __init__(self, name):
        """
        Constructor, creates a new Zyre node. Note that until you start the
        node it is silent and invisible to other nodes on the network.
        The node name is provided to other nodes during discovery. If you
        specify NULL, Zyre generates a randomized node name from the UUID.
        """
        p = utils.lib.zyre_new(utils.to_bytes(name))
        if p == utils.ffi.NULL:
            raise MemoryError("Could not allocate person")

        # ffi.gc returns a copy of the cdata object which will have the
        # destructor called when the Python object is GC'd:
        # https://cffi.readthedocs.org/en/latest/using.html#ffi-interface
        self._p = utils.ffi.gc(p, libzyre_destructors.zyre_destroy_py)

    def uuid(self):
        """
        Return our node UUID string, after successful initialization
        """
        return utils.lib.zyre_uuid(self._p)

    def name(self):
        """
        Return our node name, after successful initialization. First 6
        characters of UUID by default.
        """
        return utils.lib.zyre_name(self._p)

    def set_name(self, name):
        """
        Set the public name of this node overriding the default. The name is
        provide during discovery and come in each ENTER message.
        """
        utils.lib.zyre_set_name(self._p, utils.to_bytes(name))

    def set_header(self, name, format, *format_args):
        """
        Set node header; these are provided to other nodes during discovery
        and come in each ENTER message.
        """
        utils.lib.zyre_set_header(self._p, utils.to_bytes(name), format, *format_args)

    def set_verbose(self):
        """
        Set verbose mode; this tells the node to log all traffic as well as
        all major events.
        """
        utils.lib.zyre_set_verbose(self._p)

    def set_port(self, port_nbr):
        """
        Set UDP beacon discovery port; defaults to 5670, this call overrides
        that so you can create independent clusters on the same network, for
        e.g. development vs. production. Has no effect after zyre_start().
        """
        utils.lib.zyre_set_port(self._p, port_nbr)

    def set_beacon_peer_port(self, port_nbr):
        """
        Set the TCP port bound by the ROUTER peer-to-peer socket (beacon mode).
        Defaults to * (the port is randomly assigned by the system).
        This call overrides this, to bypass some firewall issues when ports are
        random. Has no effect after zyre_start().
        """
        utils.lib.zyre_set_beacon_peer_port(self._p, port_nbr)

    def set_evasive_timeout(self, interval):
        """
        Set the peer evasiveness timeout, in milliseconds. Default is 5000.
        This can be tuned in order to deal with expected network conditions
        and the response time expected by the application. This is tied to
        the beacon interval and rate of messages received.
        """
        utils.lib.zyre_set_evasive_timeout(self._p, interval)

    def set_silent_timeout(self, interval):
        """
        Set the peer silence timeout, in milliseconds. Default is 5000.
        This can be tuned in order to deal with expected network conditions
        and the response time expected by the application. This is tied to
        the beacon interval and rate of messages received.
        Silence is triggered one second after the timeout if peer has not
        answered ping and has not sent any message.
        NB: this is currently redundant with the evasiveness timeout. Both
        affect the same timeout value.
        """
        utils.lib.zyre_set_silent_timeout(self._p, interval)

    def set_expired_timeout(self, interval):
        """
        Set the peer expiration timeout, in milliseconds. Default is 30000.
        This can be tuned in order to deal with expected network conditions
        and the response time expected by the application. This is tied to
        the beacon interval and rate of messages received.
        """
        utils.lib.zyre_set_expired_timeout(self._p, interval)

    def set_interval(self, interval):
        """
        Set UDP beacon discovery interval, in milliseconds. Default is instant
        beacon exploration followed by pinging every 1,000 msecs.
        """
        utils.lib.zyre_set_interval(self._p, interval)

    def set_interface(self, value):
        """
        Set network interface for UDP beacons. If you do not set this, CZMQ will
        choose an interface for you. On boxes with several interfaces you should
        specify which one you want to use, or strange things can happen.
        The interface may by specified by either the interface name e.g. "eth0" or
        an IP address associalted with the interface e.g. "192.168.0.1"
        """
        utils.lib.zyre_set_interface(self._p, utils.to_bytes(value))

    def set_endpoint(self, format, *format_args):
        """
        By default, Zyre binds to an ephemeral TCP port and broadcasts the local
        host name using UDP beaconing. When you call this method, Zyre will use
        gossip discovery instead of UDP beaconing. You MUST set-up the gossip
        service separately using zyre_gossip_bind() and _connect(). Note that the
        endpoint MUST be valid for both bind and connect operations. You can use
        inproc://, ipc://, or tcp:// transports (for tcp://, use an IP address
        that is meaningful to remote as well as local nodes). Returns 0 if
        the bind was successful, else -1.
        """
        return utils.lib.zyre_set_endpoint(self._p, format, *format_args)

    def set_contest_in_group(self, group):
        """
        This options enables a peer to actively contest for leadership in the
        given group. If this option is not set the peer will still participate in
        elections but never gets elected. This ensures that a consent for a leader
        is reached within a group even though not every peer is contesting for
        leadership.
        """
        utils.lib.zyre_set_contest_in_group(self._p, utils.to_bytes(group))

    def set_advertised_endpoint(self, value):
        """
        Set an alternative endpoint value when using GOSSIP ONLY. This is useful
        if you're advertising an endpoint behind a NAT.
        """
        utils.lib.zyre_set_advertised_endpoint(self._p, utils.to_bytes(value))

    def set_zcert(self, zcert):
        """
        Apply a azcert to a Zyre node.
        """
        utils.lib.zyre_set_zcert(self._p, zcert._p)

    def set_zap_domain(self, domain):
        """
        Specify the ZAP domain (for use with CURVE).
        """
        utils.lib.zyre_set_zap_domain(self._p, utils.to_bytes(domain))

    def gossip_bind(self, format, *format_args):
        """
        Set-up gossip discovery of other nodes. At least one node in the cluster
        must bind to a well-known gossip endpoint, so other nodes can connect to
        it. Note that gossip endpoints are completely distinct from Zyre node
        endpoints, and should not overlap (they can use the same transport).
        """
        utils.lib.zyre_gossip_bind(self._p, format, *format_args)

    def gossip_connect(self, format, *format_args):
        """
        Set-up gossip discovery of other nodes. A node may connect to multiple
        other nodes, for redundancy paths. For details of the gossip network
        design, see the CZMQ zgossip class.
        """
        utils.lib.zyre_gossip_connect(self._p, format, *format_args)

    def gossip_connect_curve(self, public_key, format, *format_args):
        """
        Set-up gossip discovery with CURVE enabled.
        """
        utils.lib.zyre_gossip_connect_curve(self._p, utils.to_bytes(public_key), format, *format_args)

    def gossip_unpublish(self, node):
        """
        Unpublish a GOSSIP node from local list, useful in removing nodes from list when they EXIT
        """
        utils.lib.zyre_gossip_unpublish(self._p, utils.to_bytes(node))

    def start(self):
        """
        Start node, after setting header values. When you start a node it
        begins discovery and connection. Returns 0 if OK, -1 if it wasn't
        possible to start the node.
        """
        return utils.lib.zyre_start(self._p)

    def stop(self):
        """
        Stop node; this signals to other peers that this node will go away.
        This is polite; however you can also just destroy the node without
        stopping it.
        """
        utils.lib.zyre_stop(self._p)

    def join(self, group):
        """
        Join a named group; after joining a group you can send messages to
        the group and all Zyre nodes in that group will receive them.
        """
        return utils.lib.zyre_join(self._p, utils.to_bytes(group))

    def leave(self, group):
        """
        Leave a group
        """
        return utils.lib.zyre_leave(self._p, utils.to_bytes(group))

    def recv(self):
        """
        Receive next message from network; the message may be a control
        message (ENTER, EXIT, JOIN, LEAVE) or data (WHISPER, SHOUT).
        Returns zmsg_t object, or NULL if interrupted
        """
        return utils.lib.zyre_recv(self._p)

    def whisper(self, peer, msg_p):
        """
        Send message to single peer, specified as a UUID string
        Destroys message after sending
        """
        return utils.lib.zyre_whisper(self._p, utils.to_bytes(peer), utils.ffi.new("zmsg_t **", msg_p._p))

    def shout(self, group, msg_p):
        """
        Send message to a named group
        Destroys message after sending
        """
        return utils.lib.zyre_shout(self._p, utils.to_bytes(group), utils.ffi.new("zmsg_t **", msg_p._p))

    def whispers(self, peer, format, *format_args):
        """
        Send formatted string to a single peer specified as UUID string
        """
        return utils.lib.zyre_whispers(self._p, utils.to_bytes(peer), format, *format_args)

    def shouts(self, group, format, *format_args):
        """
        Send formatted string to a named group
        """
        return utils.lib.zyre_shouts(self._p, utils.to_bytes(group), format, *format_args)

    def peers(self):
        """
        Return zlist of current peer ids.
        """
        return utils.lib.zyre_peers(self._p)

    def peers_by_group(self, name):
        """
        Return zlist of current peers of this group.
        """
        return utils.lib.zyre_peers_by_group(self._p, utils.to_bytes(name))

    def own_groups(self):
        """
        Return zlist of currently joined groups.
        """
        return utils.lib.zyre_own_groups(self._p)

    def peer_groups(self):
        """
        Return zlist of groups known through connected peers.
        """
        return utils.lib.zyre_peer_groups(self._p)

    def peer_address(self, peer):
        """
        Return the endpoint of a connected peer.
        Returns empty string if peer does not exist.
        """
        return utils.lib.zyre_peer_address(self._p, utils.to_bytes(peer))

    def peer_header_value(self, peer, name):
        """
        Return the value of a header of a conected peer.
        Returns null if peer or key doesn't exits.
        """
        return utils.lib.zyre_peer_header_value(self._p, utils.to_bytes(peer), utils.to_bytes(name))

    def require_peer(self, uuid, endpoint, public_key):
        """
        Explicitly connect to a peer
        """
        return utils.lib.zyre_require_peer(self._p, utils.to_bytes(uuid), utils.to_bytes(endpoint), utils.to_bytes(public_key))

    def socket(self):
        """
        Return socket for talking to the Zyre node, for polling
        """
        return utils.lib.zyre_socket(self._p)

    def socket_zmq(self):
        """
        Return underlying ZMQ socket for talking to the Zyre node,
        for polling with libzmq (base ZMQ library)
        """
        return utils.lib.zyre_socket_zmq(self._p)

    def print_py(self):
        """
        Print zyre node information to stdout
        """
        utils.lib.zyre_print(self._p)

    @staticmethod
    def version():
        """
        Return the Zyre version for run-time API detection; returns
        major * 10000 + minor * 100 + patch, as a single integer.
        """
        return utils.lib.zyre_version()

    @staticmethod
    def test(verbose):
        """
        Self test of this class.
        """
        utils.lib.zyre_test(verbose)

################################################################################
#  THIS FILE IS 100% GENERATED BY ZPROJECT; DO NOT EDIT EXCEPT EXPERIMENTALLY  #
#  Read the zproject/README.md for information about making permanent changes. #
################################################################################
