################################################################################
#  THIS FILE IS 100% GENERATED BY ZPROJECT; DO NOT EDIT EXCEPT EXPERIMENTALLY  #
#  Read the zproject/README.md for information about making permanent changes. #
################################################################################

module Zyre
  module FFI

    # An open-source framework for proximity-based P2P apps
    # @note This class is 100% generated using zproject.
    class Zyre
      # Raised when one tries to use an instance of {Zyre} after
      # the internal pointer to the native object has been nullified.
      class DestroyedError < RuntimeError; end

      # Boilerplate for self pointer, initializer, and finalizer
      class << self
        alias :__new :new
      end
      # Attaches the pointer _ptr_ to this instance and defines a finalizer for
      # it if necessary.
      # @param ptr [::FFI::Pointer]
      # @param finalize [Boolean]
      def initialize(ptr, finalize = true)
        @ptr = ptr
        if @ptr.null?
          @ptr = nil # Remove null pointers so we don't have to test for them.
        elsif finalize
          @finalizer = self.class.create_finalizer_for @ptr
          ObjectSpace.define_finalizer self, @finalizer
        end
      end
      # @param ptr [::FFI::Pointer]
      # @return [Proc]
      def self.create_finalizer_for(ptr)
        ptr_ptr = ::FFI::MemoryPointer.new :pointer

        Proc.new do
          ptr_ptr.write_pointer ptr
          ::Zyre::FFI.zyre_destroy ptr_ptr
        end
      end
      # @return [Boolean]
      def null?
        !@ptr or @ptr.null?
      end
      # Return internal pointer
      # @return [::FFI::Pointer]
      def __ptr
        raise DestroyedError unless @ptr
        @ptr
      end
      # So external Libraries can just pass the Object to a FFI function which expects a :pointer
      alias_method :to_ptr, :__ptr
      # Nullify internal pointer and return pointer pointer.
      # @note This detaches the current instance from the native object
      #   and thus makes it unusable.
      # @return [::FFI::MemoryPointer] the pointer pointing to a pointer
      #   pointing to the native object
      def __ptr_give_ref
        raise DestroyedError unless @ptr
        ptr_ptr = ::FFI::MemoryPointer.new :pointer
        ptr_ptr.write_pointer @ptr
        __undef_finalizer if @finalizer
        @ptr = nil
        ptr_ptr
      end
      # Undefines the finalizer for this object.
      # @note Only use this if you need to and can guarantee that the native
      #   object will be freed by other means.
      # @return [void]
      def __undef_finalizer
        ObjectSpace.undefine_finalizer self
        @finalizer = nil
      end

      # Constructor, creates a new Zyre node. Note that until you start the
      # node it is silent and invisible to other nodes on the network.
      # The node name is provided to other nodes during discovery. If you
      # specify NULL, Zyre generates a randomized node name from the UUID.
      # @param name [String, #to_s, nil]
      # @return [Zyre::Zyre]
      def self.new(name)
        ptr = ::Zyre::FFI.zyre_new(name)
        __new ptr
      end

      # Destructor, destroys a Zyre node. When you destroy a node, any
      # messages it is sending or receiving will be discarded.
      #
      # @return [void]
      def destroy()
        return unless @ptr
        self_p = __ptr_give_ref
        result = ::Zyre::FFI.zyre_destroy(self_p)
        result
      end

      # Return our node UUID string, after successful initialization
      #
      # @return [String]
      def uuid()
        raise DestroyedError unless @ptr
        self_p = @ptr
        result = ::Zyre::FFI.zyre_uuid(self_p)
        result
      end

      # Return our node name, after successful initialization. First 6
      # characters of UUID by default.
      #
      # @return [String]
      def name()
        raise DestroyedError unless @ptr
        self_p = @ptr
        result = ::Zyre::FFI.zyre_name(self_p)
        result
      end

      # Set the public name of this node overriding the default. The name is
      # provide during discovery and come in each ENTER message.
      #
      # @param name [String, #to_s, nil]
      # @return [void]
      def set_name(name)
        raise DestroyedError unless @ptr
        self_p = @ptr
        result = ::Zyre::FFI.zyre_set_name(self_p, name)
        result
      end

      # Set node header; these are provided to other nodes during discovery
      # and come in each ENTER message.
      #
      # @param name [String, #to_s, nil]
      # @param format [String, #to_s, nil]
      # @param args [Array<Object>] see https://github.com/ffi/ffi/wiki/examples#using-varargs
      # @return [void]
      def set_header(name, format, *args)
        raise DestroyedError unless @ptr
        self_p = @ptr
        result = ::Zyre::FFI.zyre_set_header(self_p, name, format, *args)
        result
      end

      # Set verbose mode; this tells the node to log all traffic as well as
      # all major events.
      #
      # @return [void]
      def set_verbose()
        raise DestroyedError unless @ptr
        self_p = @ptr
        result = ::Zyre::FFI.zyre_set_verbose(self_p)
        result
      end

      # Set UDP beacon discovery port; defaults to 5670, this call overrides
      # that so you can create independent clusters on the same network, for
      # e.g. development vs. production. Has no effect after zyre_start().
      #
      # @param port_nbr [Integer, #to_int, #to_i]
      # @return [void]
      def set_port(port_nbr)
        raise DestroyedError unless @ptr
        self_p = @ptr
        port_nbr = Integer(port_nbr)
        result = ::Zyre::FFI.zyre_set_port(self_p, port_nbr)
        result
      end

      # Set the TCP port bound by the ROUTER peer-to-peer socket (beacon mode).
      # Defaults to * (the port is randomly assigned by the system).
      # This call overrides this, to bypass some firewall issues when ports are
      # random. Has no effect after zyre_start().
      #
      # @param port_nbr [Integer, #to_int, #to_i]
      # @return [void]
      def set_beacon_peer_port(port_nbr)
        raise DestroyedError unless @ptr
        self_p = @ptr
        port_nbr = Integer(port_nbr)
        result = ::Zyre::FFI.zyre_set_beacon_peer_port(self_p, port_nbr)
        result
      end

      # Set the peer evasiveness timeout, in milliseconds. Default is 5000.
      # This can be tuned in order to deal with expected network conditions
      # and the response time expected by the application. This is tied to
      # the beacon interval and rate of messages received.
      #
      # @param interval [Integer, #to_int, #to_i]
      # @return [void]
      def set_evasive_timeout(interval)
        raise DestroyedError unless @ptr
        self_p = @ptr
        interval = Integer(interval)
        result = ::Zyre::FFI.zyre_set_evasive_timeout(self_p, interval)
        result
      end

      # Set the peer silence timeout, in milliseconds. Default is 5000.
      # This can be tuned in order to deal with expected network conditions
      # and the response time expected by the application. This is tied to
      # the beacon interval and rate of messages received.
      # Silence is triggered one second after the timeout if peer has not
      # answered ping and has not sent any message.
      # NB: this is currently redundant with the evasiveness timeout. Both
      # affect the same timeout value.
      #
      # @param interval [Integer, #to_int, #to_i]
      # @return [void]
      def set_silent_timeout(interval)
        raise DestroyedError unless @ptr
        self_p = @ptr
        interval = Integer(interval)
        result = ::Zyre::FFI.zyre_set_silent_timeout(self_p, interval)
        result
      end

      # Set the peer expiration timeout, in milliseconds. Default is 30000.
      # This can be tuned in order to deal with expected network conditions
      # and the response time expected by the application. This is tied to
      # the beacon interval and rate of messages received.
      #
      # @param interval [Integer, #to_int, #to_i]
      # @return [void]
      def set_expired_timeout(interval)
        raise DestroyedError unless @ptr
        self_p = @ptr
        interval = Integer(interval)
        result = ::Zyre::FFI.zyre_set_expired_timeout(self_p, interval)
        result
      end

      # Set UDP beacon discovery interval, in milliseconds. Default is instant
      # beacon exploration followed by pinging every 1,000 msecs.
      #
      # @param interval [Integer, #to_int, #to_i]
      # @return [void]
      def set_interval(interval)
        raise DestroyedError unless @ptr
        self_p = @ptr
        interval = Integer(interval)
        result = ::Zyre::FFI.zyre_set_interval(self_p, interval)
        result
      end

      # Set network interface for UDP beacons. If you do not set this, CZMQ will
      # choose an interface for you. On boxes with several interfaces you should
      # specify which one you want to use, or strange things can happen.
      # The interface may by specified by either the interface name e.g. "eth0" or
      # an IP address associalted with the interface e.g. "192.168.0.1"
      #
      # @param value [String, #to_s, nil]
      # @return [void]
      def set_interface(value)
        raise DestroyedError unless @ptr
        self_p = @ptr
        result = ::Zyre::FFI.zyre_set_interface(self_p, value)
        result
      end

      # By default, Zyre binds to an ephemeral TCP port and broadcasts the local
      # host name using UDP beaconing. When you call this method, Zyre will use
      # gossip discovery instead of UDP beaconing. You MUST set-up the gossip
      # service separately using zyre_gossip_bind() and _connect(). Note that the
      # endpoint MUST be valid for both bind and connect operations. You can use
      # inproc://, ipc://, or tcp:// transports (for tcp://, use an IP address
      # that is meaningful to remote as well as local nodes). Returns 0 if
      # the bind was successful, else -1.
      #
      # @param format [String, #to_s, nil]
      # @param args [Array<Object>] see https://github.com/ffi/ffi/wiki/examples#using-varargs
      # @return [Integer]
      def set_endpoint(format, *args)
        raise DestroyedError unless @ptr
        self_p = @ptr
        result = ::Zyre::FFI.zyre_set_endpoint(self_p, format, *args)
        result
      end

      # This options enables a peer to actively contest for leadership in the
      # given group. If this option is not set the peer will still participate in
      # elections but never gets elected. This ensures that a consent for a leader
      # is reached within a group even though not every peer is contesting for
      # leadership.
      #
      # @param group [String, #to_s, nil]
      # @return [void]
      def set_contest_in_group(group)
        raise DestroyedError unless @ptr
        self_p = @ptr
        result = ::Zyre::FFI.zyre_set_contest_in_group(self_p, group)
        result
      end

      # Set an alternative endpoint value when using GOSSIP ONLY. This is useful
      # if you're advertising an endpoint behind a NAT.
      #
      # @param value [String, #to_s, nil]
      # @return [void]
      def set_advertised_endpoint(value)
        raise DestroyedError unless @ptr
        self_p = @ptr
        result = ::Zyre::FFI.zyre_set_advertised_endpoint(self_p, value)
        result
      end

      # Apply a azcert to a Zyre node.
      #
      # @param zcert [::FFI::Pointer, #to_ptr]
      # @return [void]
      def set_zcert(zcert)
        raise DestroyedError unless @ptr
        self_p = @ptr
        result = ::Zyre::FFI.zyre_set_zcert(self_p, zcert)
        result
      end

      # Specify the ZAP domain (for use with CURVE).
      #
      # @param domain [String, #to_s, nil]
      # @return [void]
      def set_zap_domain(domain)
        raise DestroyedError unless @ptr
        self_p = @ptr
        result = ::Zyre::FFI.zyre_set_zap_domain(self_p, domain)
        result
      end

      # Set-up gossip discovery of other nodes. At least one node in the cluster
      # must bind to a well-known gossip endpoint, so other nodes can connect to
      # it. Note that gossip endpoints are completely distinct from Zyre node
      # endpoints, and should not overlap (they can use the same transport).
      #
      # @param format [String, #to_s, nil]
      # @param args [Array<Object>] see https://github.com/ffi/ffi/wiki/examples#using-varargs
      # @return [void]
      def gossip_bind(format, *args)
        raise DestroyedError unless @ptr
        self_p = @ptr
        result = ::Zyre::FFI.zyre_gossip_bind(self_p, format, *args)
        result
      end

      # Set-up gossip discovery of other nodes. A node may connect to multiple
      # other nodes, for redundancy paths. For details of the gossip network
      # design, see the CZMQ zgossip class.
      #
      # @param format [String, #to_s, nil]
      # @param args [Array<Object>] see https://github.com/ffi/ffi/wiki/examples#using-varargs
      # @return [void]
      def gossip_connect(format, *args)
        raise DestroyedError unless @ptr
        self_p = @ptr
        result = ::Zyre::FFI.zyre_gossip_connect(self_p, format, *args)
        result
      end

      # Set-up gossip discovery with CURVE enabled.
      #
      # @param public_key [String, #to_s, nil]
      # @param format [String, #to_s, nil]
      # @param args [Array<Object>] see https://github.com/ffi/ffi/wiki/examples#using-varargs
      # @return [void]
      def gossip_connect_curve(public_key, format, *args)
        raise DestroyedError unless @ptr
        self_p = @ptr
        result = ::Zyre::FFI.zyre_gossip_connect_curve(self_p, public_key, format, *args)
        result
      end

      # Unpublish a GOSSIP node from local list, useful in removing nodes from list when they EXIT
      #
      # @param node [String, #to_s, nil]
      # @return [void]
      def gossip_unpublish(node)
        raise DestroyedError unless @ptr
        self_p = @ptr
        result = ::Zyre::FFI.zyre_gossip_unpublish(self_p, node)
        result
      end

      # Start node, after setting header values. When you start a node it
      # begins discovery and connection. Returns 0 if OK, -1 if it wasn't
      # possible to start the node.
      #
      # @return [Integer]
      def start()
        raise DestroyedError unless @ptr
        self_p = @ptr
        result = ::Zyre::FFI.zyre_start(self_p)
        result
      end

      # Stop node; this signals to other peers that this node will go away.
      # This is polite; however you can also just destroy the node without
      # stopping it.
      #
      # @return [void]
      def stop()
        raise DestroyedError unless @ptr
        self_p = @ptr
        result = ::Zyre::FFI.zyre_stop(self_p)
        result
      end

      # Join a named group; after joining a group you can send messages to
      # the group and all Zyre nodes in that group will receive them.
      #
      # @param group [String, #to_s, nil]
      # @return [Integer]
      def join(group)
        raise DestroyedError unless @ptr
        self_p = @ptr
        result = ::Zyre::FFI.zyre_join(self_p, group)
        result
      end

      # Leave a group
      #
      # @param group [String, #to_s, nil]
      # @return [Integer]
      def leave(group)
        raise DestroyedError unless @ptr
        self_p = @ptr
        result = ::Zyre::FFI.zyre_leave(self_p, group)
        result
      end

      # Receive next message from network; the message may be a control
      # message (ENTER, EXIT, JOIN, LEAVE) or data (WHISPER, SHOUT).
      # Returns zmsg_t object, or NULL if interrupted
      #
      # @return [::FFI::Pointer]
      def recv()
        raise DestroyedError unless @ptr
        self_p = @ptr
        result = ::Zyre::FFI.zyre_recv(self_p)
        result
      end

      # Send message to single peer, specified as a UUID string
      # Destroys message after sending
      #
      # @param peer [String, #to_s, nil]
      # @param msg_p [::FFI::Pointer, #to_ptr]
      # @return [Integer]
      def whisper(peer, msg_p)
        raise DestroyedError unless @ptr
        self_p = @ptr
        result = ::Zyre::FFI.zyre_whisper(self_p, peer, msg_p)
        result
      end

      # Send message to a named group
      # Destroys message after sending
      #
      # @param group [String, #to_s, nil]
      # @param msg_p [::FFI::Pointer, #to_ptr]
      # @return [Integer]
      def shout(group, msg_p)
        raise DestroyedError unless @ptr
        self_p = @ptr
        result = ::Zyre::FFI.zyre_shout(self_p, group, msg_p)
        result
      end

      # Send formatted string to a single peer specified as UUID string
      #
      # @param peer [String, #to_s, nil]
      # @param format [String, #to_s, nil]
      # @param args [Array<Object>] see https://github.com/ffi/ffi/wiki/examples#using-varargs
      # @return [Integer]
      def whispers(peer, format, *args)
        raise DestroyedError unless @ptr
        self_p = @ptr
        result = ::Zyre::FFI.zyre_whispers(self_p, peer, format, *args)
        result
      end

      # Send formatted string to a named group
      #
      # @param group [String, #to_s, nil]
      # @param format [String, #to_s, nil]
      # @param args [Array<Object>] see https://github.com/ffi/ffi/wiki/examples#using-varargs
      # @return [Integer]
      def shouts(group, format, *args)
        raise DestroyedError unless @ptr
        self_p = @ptr
        result = ::Zyre::FFI.zyre_shouts(self_p, group, format, *args)
        result
      end

      # Return zlist of current peer ids.
      #
      # @return [::FFI::Pointer]
      def peers()
        raise DestroyedError unless @ptr
        self_p = @ptr
        result = ::Zyre::FFI.zyre_peers(self_p)
        result
      end

      # Return zlist of current peers of this group.
      #
      # @param name [String, #to_s, nil]
      # @return [::FFI::Pointer]
      def peers_by_group(name)
        raise DestroyedError unless @ptr
        self_p = @ptr
        result = ::Zyre::FFI.zyre_peers_by_group(self_p, name)
        result
      end

      # Return zlist of currently joined groups.
      #
      # @return [::FFI::Pointer]
      def own_groups()
        raise DestroyedError unless @ptr
        self_p = @ptr
        result = ::Zyre::FFI.zyre_own_groups(self_p)
        result
      end

      # Return zlist of groups known through connected peers.
      #
      # @return [::FFI::Pointer]
      def peer_groups()
        raise DestroyedError unless @ptr
        self_p = @ptr
        result = ::Zyre::FFI.zyre_peer_groups(self_p)
        result
      end

      # Return the endpoint of a connected peer.
      # Returns empty string if peer does not exist.
      #
      # @param peer [String, #to_s, nil]
      # @return [::FFI::AutoPointer]
      def peer_address(peer)
        raise DestroyedError unless @ptr
        self_p = @ptr
        result = ::Zyre::FFI.zyre_peer_address(self_p, peer)
        result = ::FFI::AutoPointer.new(result, LibC.method(:free))
        result
      end

      # Return the value of a header of a conected peer.
      # Returns null if peer or key doesn't exits.
      #
      # @param peer [String, #to_s, nil]
      # @param name [String, #to_s, nil]
      # @return [::FFI::AutoPointer]
      def peer_header_value(peer, name)
        raise DestroyedError unless @ptr
        self_p = @ptr
        result = ::Zyre::FFI.zyre_peer_header_value(self_p, peer, name)
        result = ::FFI::AutoPointer.new(result, LibC.method(:free))
        result
      end

      # Explicitly connect to a peer
      #
      # @param uuid [String, #to_s, nil]
      # @param endpoint [String, #to_s, nil]
      # @param public_key [String, #to_s, nil]
      # @return [Integer]
      def require_peer(uuid, endpoint, public_key)
        raise DestroyedError unless @ptr
        self_p = @ptr
        result = ::Zyre::FFI.zyre_require_peer(self_p, uuid, endpoint, public_key)
        result
      end

      # Return socket for talking to the Zyre node, for polling
      #
      # @return [::FFI::Pointer]
      def socket()
        raise DestroyedError unless @ptr
        self_p = @ptr
        result = ::Zyre::FFI.zyre_socket(self_p)
        result
      end

      # Return underlying ZMQ socket for talking to the Zyre node,
      # for polling with libzmq (base ZMQ library)
      #
      # @return [::FFI::Pointer]
      def socket_zmq()
        raise DestroyedError unless @ptr
        self_p = @ptr
        result = ::Zyre::FFI.zyre_socket_zmq(self_p)
        result
      end

      # Print zyre node information to stdout
      #
      # @return [void]
      def print()
        raise DestroyedError unless @ptr
        self_p = @ptr
        result = ::Zyre::FFI.zyre_print(self_p)
        result
      end

      # Return the Zyre version for run-time API detection; returns
      # major * 10000 + minor * 100 + patch, as a single integer.
      #
      # @return [Integer]
      def self.version()
        result = ::Zyre::FFI.zyre_version()
        result
      end

      # Self test of this class.
      #
      # @param verbose [Boolean]
      # @return [void]
      def self.test(verbose)
        verbose = !(0==verbose||!verbose) # boolean
        result = ::Zyre::FFI.zyre_test(verbose)
        result
      end
    end
  end
end

################################################################################
#  THIS FILE IS 100% GENERATED BY ZPROJECT; DO NOT EDIT EXCEPT EXPERIMENTALLY  #
#  Read the zproject/README.md for information about making permanent changes. #
################################################################################
