#!/usr/bin/env bash
################################################################################
#  THIS FILE IS 100% GENERATED BY ZPROJECT; DO NOT EDIT EXCEPT EXPERIMENTALLY  #
#  Read the zproject/README.md for information about making permanent changes. #
################################################################################

# Set this to enable verbose profiling
[ -n "${CI_TIME-}" ] || CI_TIME=""
case "$CI_TIME" in
    [Yy][Ee][Ss]|[Oo][Nn]|[Tt][Rr][Uu][Ee])
        CI_TIME="time -p " ;;
    [Nn][Oo]|[Oo][Ff][Ff]|[Ff][Aa][Ll][Ss][Ee])
        CI_TIME="" ;;
esac

# Set this to enable verbose tracing
[ -n "${CI_TRACE-}" ] || CI_TRACE="no"
case "$CI_TRACE" in
    [Nn][Oo]|[Oo][Ff][Ff]|[Ff][Aa][Ll][Ss][Ee])
        set +x ;;
    [Yy][Ee][Ss]|[Oo][Nn]|[Tt][Rr][Uu][Ee])
        set -x ;;
esac

# Parse parameters
while [[ $# -gt 0 ]]; do
    key="$1"
    case $key in
        -i|--incremental)
        INCREMENTAL=0
        ;;
        -u|--update)
        UPDATE=0
        ;;
        *)
                # unknown option
        ;;
    esac
    shift # past argument or value
done

if [ $INCREMENTAL ] && [ $UPDATE ]; then
    echo Error: Incremental and update are exclusiv!
    exit -1
fi

# Download cross compiler and sysroot
if [ ! -d $PWD/tools ]; then
    git clone --depth 1 https://github.com/raspberrypi/tools
fi
if [ $UPDATE ]; then
    ( cd tools && git pull --rebase ) || exit 1
fi

# Cross build for the Raspberry Pi
if [ -d "./tmp" ]; then
    # Proto installation area for this project and its deps
    rm -rf ./tmp
fi
if [ -d "./tmp-deps" ]; then
    # Checkout/unpack and build area for dependencies
    rm -rf ./tmp-deps
fi
mkdir -p tmp tmp-deps

BUILD_PREFIX=$PWD/tmp
TOOLCHAIN_HOST="arm-linux-gnueabihf"
TOOLCHAIN_PATH="${PWD}/tools/arm-bcm2708/arm-rpi-4.9.3-linux-gnueabihf/bin"
SYSROOT=$PWD/tools/arm-bcm2708/arm-rpi-4.9.3-linux-gnueabihf/arm-linux-gnueabihf/sysroot

CFLAGS="--sysroot=${SYSROOT} -I${BUILD_PREFIX}/include"
CPPFLAGS="--sysroot=${SYSROOT} -I${BUILD_PREFIX}/include"
CXXFLAGS="--sysroot=${SYSROOT} -I${BUILD_PREFIX}/include"
LDFLAGS="-L${BUILD_PREFIX}/lib"

CONFIG_OPTS=()
CONFIG_OPTS+=("CFLAGS=${CFLAGS}")
CONFIG_OPTS+=("CPPFLAGS=${CPPFLAGS}")
CONFIG_OPTS+=("CXXFLAGS=${CXXFLAGS}")
CONFIG_OPTS+=("LDFLAGS=${LDFLAGS}")
CONFIG_OPTS+=("PKG_CONFIG_DIR=")
CONFIG_OPTS+=("PKG_CONFIG_LIBDIR=${SYSROOT}/usr/lib/arm-linux-gnueabihf/pkgconfig:${SYSROOT}/usr/share/pkgconfig")
CONFIG_OPTS+=("PKG_CONFIG_SYSROOT=${SYSROOT}")
CONFIG_OPTS+=("PKG_CONFIG_PATH=${BUILD_PREFIX}/lib/pkgconfig")
CONFIG_OPTS+=("--prefix=${BUILD_PREFIX}")
CONFIG_OPTS+=("--host=${TOOLCHAIN_HOST}")
CONFIG_OPTS+=("--with-docs=no")

CPP="${TOOLCHAIN_PATH}/${TOOLCHAIN_HOST}-cpp"
CC="${TOOLCHAIN_PATH}/${TOOLCHAIN_HOST}-gcc"
CXX="${TOOLCHAIN_PATH}/${TOOLCHAIN_HOST}-g++"
LD="${TOOLCHAIN_PATH}/${TOOLCHAIN_HOST}-ld"
AS="${TOOLCHAIN_PATH}/${TOOLCHAIN_HOST}-as"
AR="${TOOLCHAIN_PATH}/${TOOLCHAIN_HOST}-ar"
RANLIB="${TOOLCHAIN_PATH}/${TOOLCHAIN_HOST}-ranlib"

CONFIG_OPTS+=("CPP=${CPP}")
CONFIG_OPTS+=("CC=${CC}")
CONFIG_OPTS+=("CXX=${CXX}")
CONFIG_OPTS+=("LD=${LD}")
CONFIG_OPTS+=("AS=${AS}")
CONFIG_OPTS+=("AR=${AR}")
CONFIG_OPTS+=("RANLIB=${RANLIB}")

if [ ! $INCREMENTAL ]; then
    # Clone and build dependencies
    BASE_PWD=${PWD}
    cd tmp-deps
    if [ ! -e libzmq ]; then
        $CI_TIME git clone --quiet --depth 1 https://github.com/zeromq/libzmq.git libzmq
    fi
    pushd libzmq
    (
        if [ $UPDATE ]; then
            $CI_TIME git pull --rebase
        fi
        git --no-pager log --oneline -n1
        if [ -e autogen.sh ]; then
            $CI_TIME ./autogen.sh 2> /dev/null
        fi
        if [ -e buildconf ]; then
            $CI_TIME ./buildconf 2> /dev/null
        fi
        if [ ! -e autogen.sh ] && [ ! -e buildconf ] && [ ! -e ./configure ] && [ -s ./configure.ac ]; then
            $CI_TIME libtoolize --copy --force && \
            $CI_TIME aclocal -I . && \
            $CI_TIME autoheader && \
            $CI_TIME automake --add-missing --copy && \
            $CI_TIME autoconf || \
            $CI_TIME autoreconf -fiv
        fi
        $CI_TIME ./configure "${CONFIG_OPTS[@]}"
        $CI_TIME make -j4
        $CI_TIME make install
    ) || exit 1
    popd
    cd ${BASE_PWD}

    BASE_PWD=${PWD}
    cd tmp-deps
    if [ ! -e czmq ]; then
        $CI_TIME git clone --quiet --depth 1 https://github.com/zeromq/czmq.git czmq
    fi
    pushd czmq
    (
        if [ $UPDATE ]; then
            $CI_TIME git pull --rebase
        fi
        git --no-pager log --oneline -n1
        if [ -e autogen.sh ]; then
            $CI_TIME ./autogen.sh 2> /dev/null
        fi
        if [ -e buildconf ]; then
            $CI_TIME ./buildconf 2> /dev/null
        fi
        if [ ! -e autogen.sh ] && [ ! -e buildconf ] && [ ! -e ./configure ] && [ -s ./configure.ac ]; then
            $CI_TIME libtoolize --copy --force && \
            $CI_TIME aclocal -I . && \
            $CI_TIME autoheader && \
            $CI_TIME automake --add-missing --copy && \
            $CI_TIME autoconf || \
            $CI_TIME autoreconf -fiv
        fi
        $CI_TIME ./configure "${CONFIG_OPTS[@]}"
        $CI_TIME make -j4
        $CI_TIME make install
    ) || exit 1
    popd
    cd ${BASE_PWD}

fi

# Cross build this project
pushd ../..
(
    $CI_TIME ./autogen.sh 2> /dev/null
    $CI_TIME ./configure --enable-drafts=yes "${CONFIG_OPTS[@]}"
    $CI_TIME make -j4
    $CI_TIME make install
) || exit 1
popd

################################################################################
#  THIS FILE IS 100% GENERATED BY ZPROJECT; DO NOT EDIT EXCEPT EXPERIMENTALLY  #
#  Read the zproject/README.md for information about making permanent changes. #
################################################################################
